/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.command.DebugSessionCommand;

public class ListenShmem
extends DebugSessionCommand {
    protected void doCommand() throws JDEException {
        if (this.args.size() < 1) {
            throw new JDEException("Missing name");
        }
        final String address = this.args.remove(0).toString();
        String connectSpec = "com.sun.jdi.SharedMemoryListen";
        final ListeningConnector connector = (ListeningConnector)this.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        Thread thread = new Thread("Listen on shared memory channel."){

            public void run() {
                try {
                    Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
                    Connector.Argument nameArg = argumentMap.get("name");
                    nameArg.setValue(address);
                    Jdebug.theDebugger.signalCommandResult(ListenShmem.this.appID, ListenShmem.this.cmdID);
                    Jdebug.theDebugger.signal(ListenShmem.this.appID, "message", "Listening at shared memory address: " + address);
                    connector.startListening(argumentMap);
                    VirtualMachine vm = connector.accept(argumentMap);
                    connector.stopListening(argumentMap);
                    Application app = new Application(Jdebug.theDebugger, ListenShmem.this.appID, vm);
                    if (Jdebug.theDebugger.appExists(ListenShmem.this.appID)) {
                        app.shutdown();
                        app.signal("message", "An application with the same ID already exists.");
                    }
                    Jdebug.theDebugger.addApplication(ListenShmem.this.appID, app);
                    app.signal("message", "Attached VM (shmem) " + vm.description());
                }
                catch (IOException ex) {
                    Debug.printIf(ex);
                    Jdebug.theDebugger.signal(ListenShmem.this.appID, "message", "I/O error occured while listening at shared memory address:" + address);
                }
                catch (IllegalConnectorArgumentsException ex) {
                    Jdebug.theDebugger.signal(ListenShmem.this.appID, "message", "Illegal argument error occurred while listening at shared memory address: " + address);
                }
            }
        };
        thread.start();
    }

    public Object clone() {
        return new ListenShmem();
    }
}

